% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerCompare.R
\name{powerComp}
\alias{powerComp}
\title{Comparison of the power of TSS under different models}
\usage{
powerComp(
  tss,
  null_model = "yule",
  alt_models,
  n,
  distribs = "sampled",
  sample_size = 1000L,
  test_type = "two-tailed",
  sig_lvl = 0.05,
  with_CIradius = FALSE
)
}
\arguments{
\item{tss}{Vector containing the names (as character) of the tree shape
statistics that should be compared. You may either use the short names
provided in \code{tssInfo} to use the already included TSS, or use the
name of a list object containing similar information as the entries in
\code{tssInfo}. Example:\cr
Use \code{"new_tss"} as the name for the list object
\code{new_tss} containing at least the function
\code{new_tss$func = function(tree){...}},
and optionally also the information \code{new_tss$short},
\code{new_tss$simple}, \code{new_tss$name}, \code{new_tss$type},
\code{new_tss$only_binary}, and \code{new_tss$safe_n}.}

\item{null_model}{The null model that is to be used to determine the power
of the tree shape statistics. In general, it must be a function that
produces rooted binary trees in \code{phylo} format. \cr
If the respective model is included in this
package, then specify the model and its parameters by using a character
or list. Available are all options listed under parameter \code{tm} in
the documentation of function \code{genTrees} (type \code{?genTrees}).\cr
If you want to include your own tree model, then use the
name of a list object containing the function (dependent on one parameter
\code{n}). Example: \cr
Use \code{"new_tm"} for the list object \cr
\code{new_tm <- list(func = function(n, Ntrees){...})}.}

\item{alt_models}{List containing the alternative models that are to be
used to determine the power of the tree shape statistics. Functions that
produce rooted binary trees in \code{phylo} format. The information of each
single model must be in the format described for \code{null_model}.}

\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.}

\item{distribs}{Determines how the distributions and quantiles are computed.
Available are: \cr
\itemize{
\item "sampled" (default): \code{sample_size} many trees are sample under the
respective models to determine the quantiles for the null model and how many
trees under the alternative models lie outside.
}}

\item{sample_size}{Sample size (integer >=10) if distributions are sampled
(default= 1000L).}

\item{test_type}{Determines the method. Available are: \cr
\itemize{
\item "two-tailed" (default)
}}

\item{sig_lvl}{Level of significance (default=0.05, must be >0 and <1).}

\item{with_CIradius}{Determines if the radii for the 95\%-confidence
intervals of the power values should also be computed
and returned (default = FALSE).}
}
\value{
\code{powerComp}  Numeric matrix, one row per TSS and one
column per alternative model if \code{with_CIradius} is FALSE (default).
Else a list with two such numeric matrices, the first for the power and the
second for the confidence interval radius.
}
\description{
\code{powerComp} - Compare the power of a set of TSS to identify trees
generated under different alternative models given a null model.
}
\examples{
powerComp(tss = c("Sackin", "Colless", "B1I"),
          alt_models = list(list("aldous",-1), "pda", "etm"), n=10L,
          sample_size = 40L, with_CIradius = TRUE)
}
\author{
Sophie Kersting
}
