% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrpd_pca.R
\name{xrpd_pca}
\alias{xrpd_pca}
\title{PCA of XRPD data}
\usage{
xrpd_pca(x, mean_center, bin_size, root_transform, components)
}
\arguments{
\item{x}{A multiXY list containing the XRPD data, where each item in the
list is a 2 column XY dataframe defining the x (2theta) and y (counts)
axes of each measurement. Each item in the list must have a name corresponding
to a unique sample ID.}

\item{mean_center}{A logical argument defining whether mean centering
is applied to the XRPD data (default \code{= TRUE}).}

\item{bin_size}{An integer between 1 and 10 defining whether to bin the
XRPD data to a lower resolution. This \code{bin_size} defines the number of
data points used in each bin.}

\item{root_transform}{An integer between 1 and 8 defining the root transform
to apply to the XRPD data}

\item{components}{An integer defining the number of principal components to
include in the output. Must be at least 1 less than the
number of XRPD patterns in the dataset (the default).}
}
\value{
a list with components:
\item{coords}{a dataframe containing the sample ID's for each sample and the
PCA coordinates for each dimension}
\item{loadings}{a dataframe containing the 2theta axis and the loading of
each dimension}
\item{eig}{a dataframe summarising the variance explained by each dimension}
}
\description{
\code{xrpd_pca} is used to apply principal component analysis to X-ray powder
diffraction data.
}
\details{
Applies data pre-treatment and principal components analysis to XRPD data based
based on the protocols detailed in Butler et al. (2020).
}
\examples{
data(rockjock_mixtures)

x1 <- xrpd_pca(rockjock_mixtures,
               mean_center = TRUE,
               bin_size = 1,
               root_transform = 1)

#Plot the loading of dimension 1

plot(x = x1$loadings$tth,
     y = x1$loadings$Dim.1,
     type = "l")

\dontrun{
#Fit loading 1 to the rockjock library
f1 <- fps_lm(rockjock,
             smpl = data.frame("tth" = x1$loadings$tth,
                               "counts" = x1$loadings$Dim.1),
             refs = rockjock$phases$phase_id,
             std = "QUARTZ",
             align = 0,
             p = 0.05)

plot(f1, wavelength = "Cu", interactive = TRUE)
}

}
\references{
Butler, B.M., Sila, A.M., Shepherd, K.D., Nyambura, M., Gilmore, C.J., Kourkoumelis,
N., Hillier, S., 2019. Pre-treatment of soil X-ray powder diffraction data for
cluster analysis. Geoderma 337, 413-424. doi:10.4236/ampc.2013.31A007
}
