% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powdRlib.R
\name{powdRlib}
\alias{powdRlib}
\title{Create an XRPD reference library}
\usage{
powdRlib(xrd_table, phases_table, check_names)
}
\arguments{
\item{xrd_table}{A data frame of the count intensities of the XRPD reference patterns,
all scaled to same maximum intensity, with their 2theta axis as the first column.}

\item{phases_table}{A data frame of the required data (phase ID, phase name, and reference
intensity ratio) for each reference pattern.}

\item{check_names}{A logical argument defining whether the column names in the data
supplied in \code{xrd_table} are syntactically valid variable names and are not
duplicated. Default = \code{TRUE}.}
}
\value{
a powdRlib object with components:
\item{xrd}{a data frame of the count intensities of the reference patterns}
\item{tth}{a vector of the 2theta axis}
\item{phases}{a 3 column data frame of the IDs, names and reference
intensity ratios of the reference pattern}
}
\description{
A constructor function for creating a \code{powdRlib} object from two tables of
data. The resulting \code{powdRlib} object is required when
using \code{\link{fps}} or \code{\link{afps}}.
}
\examples{
#load an example xrd_table
data(minerals_xrd)
#load an example phases_table
data(minerals_phases)

#Create a reference library object
xrd_lib <- powdRlib(xrd_table = minerals_xrd,
                    phases_table = minerals_phases)
}
