% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.powdRfps}
\alias{plot.powdRfps}
\title{Plotting elements of a powdRfps object}
\usage{
\method{plot}{powdRfps}(x, d, wavelength, interactive, ...)
}
\arguments{
\item{x}{a powdRfps object}

\item{d}{logical. Denotes whether x-axis should be d-spacing. Default = FALSE.}

\item{wavelength}{numeric. Wavelength of the measurements to be plotted (in
angstroms), only required when \code{d = TRUE}.}

\item{interactive}{logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.powdRfps} is designed to provide easy, adaptable plots
of full pattern summation outputs produced from \code{\link{fps}}.
}
\details{
The only mandatory argument is \code{x}, which must be a powdRlib object.
When seeking to inspect the results from full pattern summation, interactive
plots are particularly useful and can be specified with the \code{interactive}
argument.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

\dontrun{
fps_sand <-  fps(lib = minerals,
                smpl = soils$sandstone,
                refs = minerals$phases$phase_id,
                std = "QUA.1",
                align = 0.2)

plot(fps_sand)
plot(fps_sand, interactive = TRUE)
plot(fps_sand, d = TRUE, wavelength = 1.54, interactive = TRUE)
}
}
