% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brew.R
\name{brew}
\alias{brew}
\alias{brew_package}
\alias{brew_interactive}
\title{Set up potions for easy data retrieval}
\usage{
brew(..., file, .slot, .pkg)

brew_package(..., file, .pkg)

brew_interactive(..., file, .slot)
}
\arguments{
\item{...}{One or more \code{==} statements giving attributes to be stored; or
alternatively a \code{list} containing the same.}

\item{file}{string: optional file containing data to be stored via \code{options()}.
Valid formats are \code{.yml} or \code{.json}.}

\item{.slot}{string: optional name to mandate where data is stored. Defaults
to a random string generated by \code{stringi::stri_rand_strings}.}

\item{.pkg}{string: package name that \code{potions} is being used within. If
using \code{potions} within a package development process, set this argument
instead of \code{slot}.}
}
\value{
This function never returns an object; it is called for its' side-
effect of caching data using \code{options()}.
}
\description{
Start-up function to place a list into \code{options} with a specified
slot name.
}
\details{
The default method is to use \code{brew} and set either \code{.pkg} or \code{.slot}, but not
both. Alternatively you can use \code{brew_package()} or \code{brew_interactive()}.
Note that if neither \code{.slot} or \code{.pkg} are set, \code{potions} defaults to \code{.slot}
, unless \code{.pkg} information has previously been supplied (and \code{.slot}
information has not). This might be undesirable in a package development
situation.

If both \code{...} and \code{file} arguments are empty, this function sets up an
empty \code{potions} object in \code{options("potions-pkg")}; See \code{potions-class} for
more information on this data type. If \code{...} and \code{file} arguments
are provided, they will be amalgamated. If there are identical names in both
lists, those in \code{...} are chosen.

If the user repeatedly calls \code{brew()}, later list entries overwrite early
entries. Whole lists are not overwritten unless all top-level entry names
match.
}
\examples{
# basic usage is to pass expressions
brew(x == 1)

# lists are also permitted
brew(list(x = 2))

# as are passing lists as objects
my_list <- list(x = 3)
brew(my_list)

# optional clean-up
drain()
}
