//

#ifndef MyException_h
#define MyException_h

#include <sstream>
#include <stdexcept>
#include <string>

class my_exception : public std::runtime_error {
    std::string msg;
public:
    my_exception(const std::string &arg, const char *file, int line) :
    std::runtime_error(arg) {
        std::ostringstream o;
        o << file << ":" << line << ": " << arg;
        msg = o.str();
    }
    ~my_exception() throw() {}
    const char *what() const throw() {
        return msg.c_str();
    }
};

class my_warning : public std::runtime_error {
    std::string msg;
public:
    my_warning(const std::string &arg, const char *file, int line) :
    std::runtime_error(arg) {
        std::ostringstream o;
        o << file << ":" << line << ": " << arg;
        msg = o.str();
    }
    ~my_warning() throw() {}
    const char *what() const throw() {
        return msg.c_str();
    }
};

#define throw_line(arg) throw my_exception(arg, __FILE__, __LINE__);
#define throw_warning(arg) throw my_warning(arg, __FILE__, __LINE__);


#endif /* MyException_h */
