% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{vine_settings-class}
\alias{vine_settings-class}
\alias{vine_settings}
\alias{show,vine_settings-method}
\title{S4 class for the vine settings}
\usage{
vine_settings(train_size, refit_size, family_set = "all", vine_type = "rvine")

\S4method{show}{vine_settings}(object)
}
\arguments{
\item{train_size}{equivalent to the slot definition below}

\item{refit_size}{equivalent to the slot definition below}

\item{family_set}{equivalent to the slot definition below}

\item{vine_type}{equivalent to the slot definition below}

\item{object}{An object of class \code{vine_settings}}
}
\value{
Object of class \code{vine_settings}
}
\description{
Specify which vine copula models are
fitted and how often they are refit as well as how big the training data
set is. Remember that the estimation process is done in a rolling window
fashion and the arguments (train and refit size) will have to match with
the arguments of the also to be specified \code{\link{marginal_settings}}.
}
\section{Functions}{
\itemize{
\item \code{vine_settings()}: Class constructor taking the arguments
specified in the slots below

}}
\section{Slots}{

\describe{
\item{\code{train_size}}{Positive count specifying the training data size.}

\item{\code{refit_size}}{Positive count specifying for how many periods a vine is
used}

\item{\code{family_set}}{Character vector specifying the family of copulas that are
used. For possible choices see \code{\link[rvinecopulib:bicop]{rvinecopulib::bicop}}. Note for conditional
sampling just parametric copula families are possible so do not use the
family arguments \code{all} and \code{tll}.}

\item{\code{vine_type}}{character value that specifies which vine class should be
fitted. Possible choices right now are \code{rvine} (regular vine) and \code{dvine}
(drawable vine).}
}}

\examples{
# the most basic initialization
vine_settings(100, 25)
# some individual note
vine_settings(
  train_size = 100, refit_size = 20,
  family_set = c("gumbel", "joe"),
  vine_type = "dvine"
)
}
\seealso{
\code{\link{marginal_settings}}
}
