% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stockDataDownload.R
\name{stockDataDownload}
\alias{stockDataDownload}
\title{Download stock data from the Internet}
\usage{
stockDataDownload(
  stock_symbols,
  index_symbol = NULL,
  from,
  to,
  rm_stocks_with_na = TRUE,
  local_file_path = getwd(),
  ...
)
}
\arguments{
\item{stock_symbols}{String vector containing the symbols of the stocks to be downloaded.
User can pass the market index symbol as its attribute `index_symbol`` 
(only considered when argument `index_symbol` is not passed).}

\item{index_symbol}{String of the market index symbol.}

\item{from}{String as the starting date, e.g., "2017-08-17".}

\item{to}{String as the ending date (not included), e.g., "2017-09-17".}

\item{rm_stocks_with_na}{Logical value indicating whether to remove stocks with missing values 
(ignoring leading missing values). Default is \code{TRUE}.}

\item{local_file_path}{Path where the stock data will be saved after the first time is downloaded, 
so that in future retrievals it will be locally loaded (if the same 
arguments are used). Default is \code{getwd()}. If local caching is not 
desired, it can be deactivated by setting \code{local_file_path = NULL}.}

\item{...}{Additional arguments to be passed to \code{\link[quantmod:getSymbols]{quantmod:getSymbols}}.}
}
\value{
List of 7 \code{xts} objects named `open`, `high`, `low`, `close`, `volume`, 
        `adjusted` and `index`. Note that `index` will only be returned when correct index symbols is passed.
}
\description{
This function is basically a robust wrapper for 
\code{\link[quantmod:getSymbols]{quantmod:getSymbols}} to download stock 
data from the internet. It will return 6 \code{xts} objects of the same 
dimensions named `open`, `high`, `low`, `close`, `volume`, `adjusted` 
and `index`. Additionally, it can return an \code{xts} object with an 
index. If the download for some stock fails after a few attempts they 
will be ignored and reported. Also, stocks with missing values can be 
optionally removed.
}
\examples{
\dontrun{
library(portfolioBacktest)
data(SP500_symbols)

# download data from internet
SP500_data <- stockDataDownload(stock_symbols = SP500_symbols,
                                from = "2009-01-01", to = "2009-12-31")
}

}
\seealso{
\code{\link{financialDataResample}}
}
\author{
Rui Zhou and Daniel P. Palomar
}
