% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr3.R
\name{rr3}
\alias{rr3}
\title{Randomly Round A Vector of Integers to Base 3}
\usage{
rr3(x)
}
\arguments{
\item{x}{A vector of integers (in the
sense that \code{round(x) == x}.) Can be an
\link[rvec:rvec]{rvec}.}
}
\value{
A randomly-rounded version of \code{x}.
}
\description{
Apply the 'Random Round to Base 3' (RR3)
algorithm to a vector of integers
(or doubles where \code{round(x) == x}.)
}
\details{
The RR3 algorithm is used by statistical
agencies to confidentialize data. Under the
RR3 algorithm, an integer \eqn{n}
is randomly rounded as follows:
\itemize{
\item If \eqn{n} is divisible by 3, leave it unchanged
\item If dividing \eqn{n} by 3 leaves a remainder of 1, then
round down (subtract 1) with probability 2/3,
and round up (add 2) with probability 1/3.
\item If dividing \eqn{n} by 3 leaves a remainder of 1,
then round down (subtract 2)
with probability 1/3, and round up (add 1)
with probability 2/3.
}

RR3 has some nice properties:
\itemize{
\item The randomly-rounded version of \eqn{n}
has expected value \eqn{n}.
\item If \eqn{n} non-negative, then the randomly
rounded version of \eqn{n} is non-negative.
\item If \eqn{n} is non-positive, then the randomly
rounded version of \eqn{n} is non-positive.
}
}
\examples{
x <- c(1, 5, 2, 0, -1, 3, NA)
rr3(x)
}
