% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_subset.r
\name{make_haplotypes}
\alias{make_haplotypes}
\title{Split samples from a genind object into pseudo-haplotypes}
\usage{
make_haplotypes(gid)
}
\arguments{
\item{gid}{a \link[adegenet:genind]{genind} object.}
}
\value{
a haploid genind object with an extra \link[adegenet:strata]{strata}
column called "Individual".
}
\description{
Split samples from a genind object into pseudo-haplotypes
}
\details{
Certain analyses, such as \link[=poppr.amova]{amova} work best if within-sample
variance (error) can be estimated. Practically, this is performed by
splitting the genotypes across all loci to create multiple haplotypes. This
way, the within-sample distance can be calculated and incorporated into the
model. Please note that the haplotypes generated are based on the order of
the unphased alleles in the genind object and do not represent true
haplotypes.

Haploid data will be returned un-touched.
}
\note{
The \link[adegenet:other]{other slot} will not be copied over to the new
genind object.
}
\examples{
# Diploid data is doubled -------------------------------------------------

data(nancycats)
nan9 <- nancycats[pop = 9]
nan9hap <- make_haplotypes(nan9) 
nan9              # 9 individuals from population 9
nan9hap           # 18 haplotypes
strata(nan9hap)   # strata gains a new column: Individual
indNames(nan9hap) # individuals are renamed sequentially


# Mix ploidy data can be split, but should be treated with caution --------
# 
# For example, the Pinf data set contains 86 tetraploid individuals, 
# but there appear to only be diploids and triploid genotypes. When 
# we convert to haplotypes, those with all missing data are dropped.
data(Pinf)
Pinf
pmiss <- info_table(Pinf, type = "ploidy", plot = TRUE)

# No samples appear to be triploid across all loci. This will cause
# several haplotypes to have a lot of missing data.
p_haps <- make_haplotypes(Pinf)
p_haps
head(genind2df(p_haps), n = 20)
}
\seealso{
\code{\link[=poppr.amova]{poppr.amova()}} \code{\link[pegas:amova]{pegas::amova()}} \code{\link[=as.genambig]{as.genambig()}}
}
