% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distances.r
\name{aboot}
\alias{aboot}
\alias{bootstrap}
\title{Calculate a dendrogram with bootstrap support using any distance applicable
to genind or genclone objects.}
\usage{
aboot(x, tree = "upgma", distance = "nei.dist", sample = 100,
  cutoff = 0, showtree = TRUE, missing = "mean", mcutoff = 0,
  quiet = FALSE, ...)
}
\arguments{
\item{x}{a \linkS4class{genind}, \linkS4class{genclone}, or matrix object.}

\item{tree}{one of "upgma" (Default) or "nj" defining the type of dendrogram
  to be produced, UPGMA or Neighbor-Joining.}

\item{distance}{a character or function defining the distance to be applied
  to x. Defaults to \code{\link{nei.dist}}.}

\item{sample}{An integer representing the number of bootstrap replicates
  Default is 100.}

\item{cutoff}{An integer from 0 to 100 setting the cutoff value to return the
  bootstrap values on the nodes. Default is 0.}

\item{showtree}{If \code{TRUE} (Default), a dendrogram will be plotted. If
  \code{FALSE}, nothing will be plotted.}

\item{missing}{any method to be used by \code{\link{missingno}}: "mean"
  (default), "zero", "loci", "genotype", or "ignore".}

\item{mcutoff}{a value between 0 (default) and 1 defining the percentage of
  tolerable missing data if the \code{missing} parameter is set to "loci" or
  "genotype". This should only be set if the distance metric can handle
  missing data.}

\item{quiet}{if \code{FALSE} (default), a progress bar will be printed to
  screen.}

\item{...}{any parameters to be passed off to the distance method.}
}
\value{
an object of class \code{\link[ape]{phylo}}.
}
\description{
Calculate a dendrogram with bootstrap support using any distance applicable
to genind or genclone objects.
}
\details{
This function utilizes an internal class called
  \code{\linkS4class{bootgen}} that allows bootstrapping of objects that
  inherit the genind class. This is necessary due to the fact that columns in
  the genind matrix are defined as alleles and are thus interrelated. This
  function will specifically bootstrap loci so that results are biologically
  relevant. With this function, the user can also define a custom distance to
  be performed on the genind or genclone object.
}
\note{
\code{\link{provesti.dist}} and \code{\link{diss.dist}} are exactly the
  same, but \code{\link{diss.dist}} scales better for large numbers of
  individuals (n > 125) at the cost of required memory. \subsection{missing
  data}{Missing data is not allowed by many of the distances. Thus, one of
  the first steps of this function is to treat missing data by setting it to
  the average allele frequency in the data set. If you are using a distance
  that can handle missing data (Provesti's distance), you can set
  \code{missing = "ignore"} to allow the distance function to handle any
  missing data. See \code{\link{missingno}} for details on missing
  data.}\subsection{Bruvo's Distance}{While calculation of Bruvo's distance
  is possible with this function, it is optimized in the function
  \code{\link{bruvo.boot}}.}
}
\examples{
data(nancycats)
nan9 <- popsub(nancycats, 9)

set.seed(9999)
# Generate a tree using nei's distance
neinan <- aboot(nan9, dist = nei.dist)

set.seed(9999)
# Generate a tree using custom distance
bindist <- function(x) dist(x$tab, method = "binary")
binnan <- aboot(nan9, dist = bindist)

\dontrun{
# AFLP data
data(Aeut)

# Nei's distance
anei <- aboot(Aeut, dist = nei.dist, sample = 1000, cutoff = 50)

# Rogers' distance
arog <- aboot(Aeut, dist = rogers.dist, sample = 1000, cutoff = 50)

# This can also be run on genpop objects
Aeut.gc <- as.genclone(Aeut, hierarchy=other(Aeut)$population_hierarchy[-1])
setpop(Aeut.gc) <- ~Pop/Subpop
Aeut.pop <- genind2genpop(Aeut.gc)
set.seed(5000)
aboot(Aeut.pop) # compare to Grunwald et al. 2006

}
}
\seealso{
\code{\link{nei.dist}} \code{\link{edwards.dist}}
  \code{\link{rogers.dist}} \code{\link{reynolds.dist}}
  \code{\link{provesti.dist}} \code{\link{diss.dist}}
  \code{\link{bruvo.boot}} \code{\link[ape]{boot.phylo}}
  \code{\link[adegenet]{dist.genpop}} \code{\link{dist}}
}
\keyword{bootstrap}

