% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{setpop}
\alias{setpop}
\alias{setpop,genclone-method}
\alias{setpop<-}
\alias{setpop<-,genclone-method}
\title{Manipulate the population factor of genclone objects.}
\usage{
setpop(x, formula = NULL)

setpop(x) <- value
}
\arguments{
\item{x}{a genclone object}

\item{formula}{a nested formula indicating the order of the population
hierarchy.}

\item{value}{same as formula}
}
\description{
The following methods allow the user to quickly change the population of a
genclone object.
}
\examples{
data(Aeut)
Aeut.gc <- as.genclone(Aeut)

# Notice that there are two hierarchical levels, Pop and Subpop
Aeut.gc

# Currently set on just Pop
head(pop(Aeut.gc))

# setting the hierarchy to both Pop and Subpop
setpop(Aeut.gc) <- ~Pop/Subpop
head(pop(Aeut.gc))

\dontrun{

# Can be used to create objects as well.
Aeut.old <- setpop(Aeut.gc, ~Pop)
head(pop(Aeut.old))
}
}
\author{
Zhian N. Kamvar
}

