% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwfst.R
\name{pwfst}
\alias{pwfst}
\title{Estimate the individual-level pairwise FST matrix}
\usage{
pwfst(kinship)
}
\arguments{
\item{kinship}{The \code{n}-by-\code{n} kinship matrix}
}
\value{
The \code{n}-by-\code{n} pairwise FST matrix
}
\description{
This function construct the individual-level pairwise FST matrix implied by the input kinship matrix.
If the input is the true kinship matrix, the return value corresponds to the true pairwise FST matrix.
On the other hand, if the input is the estimated kinship returned by \code{\link[=popkin]{popkin()}}, the same code results in the return value being the pairwise FST estimates described in our paper.
In all cases the diagonal of the pairwise FST matrix is zero by definition.
}
\examples{
# Construct toy data
X <- matrix(c(0,1,2,1,0,1,1,0,2), nrow=3, byrow=TRUE) # genotype matrix
subpops <- c(1,1,2) # subpopulation assignments for individuals

# NOTE: for BED-formatted input, use BEDMatrix!
# "file" is path to BED file (excluding .bed extension)
## library(BEDMatrix)
## X <- BEDMatrix(file) # load genotype matrix object

# estimate the kinship matrix from the genotypes "X"!
kinship <- popkin(X, subpops) # calculate kinship from X and optional subpop labels

# lastly, compute pairwise FST matrix from the kinship matrix
pwF <- pwfst(kinship)
 
}
