% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugs-funs.R
\name{bugs_to_df}
\alias{bugs_to_df}
\title{Extract estimated parameters from a list of BUGS outputs}
\usage{
bugs_to_df(data)
}
\arguments{
\item{data}{a named \code{list} of BUGS outputs. The output of \code{\link[=fit_trend]{fit_trend()}} or
\code{\link[=read_bugs]{read_bugs()}}}
}
\value{
A \code{data.frame}.
}
\description{
From the output of the function \code{\link[=fit_trend]{fit_trend()}} (or \code{\link[=read_bugs]{read_bugs()}}), this
function extracts estimated parameters into a \code{data.frame}.

The resulting \code{data.frame} has no particular use in \code{popbayes} but it can be
useful for users.
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(
  data              = garamba, 
  path              = temp_path,
  field_method      = "field_method",
  pref_field_method = "pref_field_method",
  conversion_A2G    = "conversion_A2G",
  rmax              = "rmax")
                                        
## Select one serie ----
a_buselaphus <- popbayes::filter_series(garamba_formatted, 
                                        location = "Garamba",
                                        species  = "Alcelaphus buselaphus")
\donttest{
## Fit population trends (requires JAGS) ----
a_buselaphus_mod <- popbayes::fit_trend(a_buselaphus, path = temp_path)

## Import BUGS outputs for one count series ----
bugs <- popbayes::read_bugs(series = "garamba__alcelaphus_buselaphus", 
                            path   = temp_path)

## Extract estimated parameters ----
popbayes::bugs_to_df(bugs)
}
}
