% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{is_leap_year}
\alias{is_leap_year}
\title{Detect leap years}
\usage{
is_leap_year(years)
}
\arguments{
\item{years}{a vector or column of year values (numeric or integer)}
}
\description{
Given a vector or column of year values (numeric or integer), \code{\link{is_leap_year}} returns a vector of equal length
of logical indicators, i.e. a vector where corresponding leap years have value TRUE, and FALSE otherwise.
}
\examples{
## can be used to assign new columns easily, e.g. a dummy indicator column
df <- data.frame(yrs=c(1900,1904,2005,1995))
df$lyd <- as.integer(is_leap_year(df$yrs))

## mostly it is useful as a condition or to indicate which rows have leap years
which(is_leap_year(df$yrs)) # 2
df[is_leap_year(df$yrs),] # 2nd row
}
\author{
Joonas Miettinen
}

