% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ltable.R
\name{expr.by.cj}
\alias{expr.by.cj}
\title{Tabulate counts and other functions with multiple factors into a long-format table}
\usage{
expr.by.cj(data, by.vars = "sex", expr = list(obs = .N), subset = NULL,
  .SDcols, ...)
}
\arguments{
\item{data}{a data.table}

\item{by.vars}{a character string vector specifying the names of variables,
by the combinations of which to evaluate the given \code{expr}}

\item{expr}{an arbitrary expression utilizing any available function
on any variable available in the data}

\item{subset}{a logical condition; data is limited accordingly before
evaluating \code{expr}}

\item{.SDcols}{advanced; passed to inside the data.table's brackets
\code{DT[, , ...]}; see \code{\link{data.table}}}

\item{...}{advanced; other arguments passed to inside the
data.table's brackets \code{DT[, , ...]}; see \code{\link{data.table}}}
}
\description{
Like \code{ltable} except faster and unrobust. For advanced users.
}
\examples{
sr <- copy(sire)
sr$agegroup <- cut(sr$dg_age, breaks=5)
## counts by default
expr.by.cj(sr, "agegroup")

## any arbitrary expression can be given
expr.by.cj(sr, "agegroup", list(mage = mean(dg_age)))
expr.by.cj(sr, "agegroup", list(mage = mean(dg_age), vage = var(dg_age)))

## only uses levels of by.vars present in data
expr.by.cj(sr, "agegroup", list(mage = mean(dg_age), vage = var(dg_age)),
           subset = dg_age < 70)
}
\author{
Joonas Miettinen
}

