% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{groups}
\alias{groups}
\alias{group_by}
\alias{ungroup}
\title{Group by one or more variables}
\usage{
group_by(.data, ..., .add = FALSE)

ungroup(x, ...)
}
\arguments{
\item{.data}{\code{data.frame}. The data to group.}

\item{...}{One or more unquoted column names to group/ungroup the data by.}

\item{.add}{\code{logical(1)}. When \code{FALSE} (the default) \code{group_by()} will override existing groups. To add to existing
groups, use \code{.add = TRUE}.}

\item{x}{A \code{data.frame}.}
}
\value{
When using \code{\link[=group_by]{group_by()}}, a \code{data.frame}, grouped by the grouping variables.

When using \code{\link[=ungroup]{ungroup()}}, \code{data.frame}.
}
\description{
Determine the groups within a \code{data.frame} to perform operations on. \code{\link[=ungroup]{ungroup()}} removes the grouping levels.
}
\examples{
group_by(mtcars, am, cyl)
ungroup(mutate(group_by(mtcars, am, cyl), sumMpg = sum(mpg)))
mtcars \%>\%
  group_by(am, cyl) \%>\%
  mutate(sumMpg = sum(mpg)) \%>\%
  ungroup()
mtcars \%>\%
  group_by(carb) \%>\%
  filter(any(gear == 5))

}
