% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_gdfa_constant.R
\name{p_gdfa_constant}
\alias{p_gdfa_constant}
\title{Gamma Discriminant Function Approach for Estimating Odds Ratio with Exposure
Measured in Pools and Potentially Subject to Multiplicative Lognormal Errors
(Constant Odds Ratio Version)}
\usage{
p_gdfa_constant(g, y, xtilde, c = NULL, errors = "processing",
  estimate_var = TRUE, start_nonvar_var = c(0.01, 1),
  lower_nonvar_var = c(-Inf, 1e-04), upper_nonvar_var = c(Inf, Inf),
  jitter_start = 0.01, hcubature_list = list(tol = 1e-08),
  nlminb_list = list(control = list(trace = 1, eval.max = 500, iter.max =
  500)), hessian_list = list(method.args = list(r = 4)),
  nlminb_object = NULL)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector with poolwise Y values, coded 0 if all members are
controls and 1 if all members are cases.}

\item{xtilde}{Numeric vector (or list of numeric vectors, if some pools have
replicates) with Xtilde values.}

\item{c}{List where each element is a numeric matrix containing the
\strong{C} values for members of a particular pool (1 row for each member).}

\item{errors}{Character string specifying the errors that X is subject to.
Choices are \code{"neither"}, \code{"processing"} for processing error only,
\code{"measurement"} for measurement error only, and \code{"both"}.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{start_nonvar_var}{Numeric vector of length 2 specifying starting value
for non-variance terms and variance terms, respectively.}

\item{lower_nonvar_var}{Numeric vector of length 2 specifying lower bound for
non-variance terms and variance terms, respectively.}

\item{upper_nonvar_var}{Numeric vector of length 2 specifying upper bound for
non-variance terms and variance terms, respectively.}

\item{jitter_start}{Numeric value specifying standard deviation for mean-0
normal jitters to add to starting values for a second try at maximizing the
log-likelihood, should the initial call to \code{\link[stats]{nlminb}} result
in non-convergence. Set to \code{NULL} for no second try.}

\item{hcubature_list}{List of arguments to pass to
\code{\link[cubature]{hcubature}} for numerical integration.}

\item{nlminb_list}{List of arguments to pass to \code{\link[stats]{nlminb}}
for log-likelihood maximization.}

\item{hessian_list}{List of arguments to pass to
\code{\link[numDeriv]{hessian}} for approximating the Hessian matrix. Only
used if \code{estimate_var = TRUE}.}

\item{nlminb_object}{Object returned from \code{\link[stats]{nlminb}} in a
prior call. Useful for bypassing log-likelihood maximization if you just want
to re-estimate the Hessian matrix with different options.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix.
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
See \code{\link{p_gdfa}}.
}
\references{
Lyles, R.H., Van Domelen, D.R., Mitchell, E.M. and Schisterman, E.F. (2015)
"A discriminant function approach to adjust for processing and measurement
error When a biomarker is assayed in pooled samples."
\emph{Int. J. Environ. Res. Public Health} \strong{12}(11): 14723--14740.

Mitchell, E.M, Lyles, R.H., and Schisterman, E.F. (2015) "Positing, fitting,
and selecting regression models for pooled biomarker data." \emph{Stat. Med}
\strong{34}(17): 2544--2558.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.

Whitcomb, B.W., Perkins, N.J., Zhang, Z., Ye, A., and Lyles, R. H. (2012)
"Assessment of skewed exposure in case-control studies with pooling."
\emph{Stat. Med.} \strong{31}: 2461--2472.
}
