% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_dfa_xerrors.R
\name{p_dfa_xerrors}
\alias{p_dfa_xerrors}
\title{Discriminant Function Approach for Estimating Odds Ratio with Normal Exposure
Measured in Pools and Potentially Subject to Errors}
\usage{
p_dfa_xerrors(g, y, xtilde, c = NULL, constant_or = TRUE,
  errors = "both", ...)
}
\arguments{
\item{g}{Numeric vector of pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector of poolwise \code{Y} values (number of cases in each
pool).}

\item{xtilde}{Numeric vector (or list of numeric vectors, if some pools have
replicates) with \code{Xtilde} values.}

\item{c}{Numeric matrix with poolwise \strong{\code{C}} values (if any), with
one row for each pool. Can be a vector if there is only 1 covariate.}

\item{constant_or}{Logical value for whether to assume a constant OR for
\code{X}, which means that \code{sigsq_1 = sigsq_0}. If \code{NULL}, model is
fit with and without this assumption, and likelihood ratio test is performed
to test it.}

\item{errors}{Character string specifying the errors that \code{X} is subject
to. Choices are \code{"neither"}, \code{"processing"} for processing error
only, \code{"measurement"} for measurement error only, and \code{"both"}.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List of point estimates, variance-covariance matrix, object returned by
\code{\link[stats]{nlminb}}, and AIC, for one or two models depending on
\code{constant_or}. If \code{constant_or = NULL}, also returns result of a
likelihood ratio test for \code{H0: sigsq_1 = sigsq_0}, which is equivalent
to \code{H0: log-OR is constant}. If \code{constant_or = NULL}, returned
objects with names ending in 1 are for model that does not assume constant
log-OR, and those ending in 2 are for model that assumes constant log-OR.
}
\description{
Archived on 7/23/18. Please use \code{\link{p_ndfa}} instead.
}
\examples{
# Load dataset containing poolwise (Y, Xtilde, C) values for pools of size
# 1, 2, and 3. Xtilde values are affected by processing error.
data(pdat1)

# Estimate log-OR for X and Y adjusted for C, ignoring processing error
fit1 <- p_dfa_xerrors(g = pdat1$g, y = pdat1$numcases, xtilde = pdat1$xtilde,
                      c = pdat1$c, errors = "neither")
fit1$estimates

# Repeat, but accounting for processing error. Closer to true log-OR of 0.5.
fit2 <- p_dfa_xerrors(g = pdat1$g, y = pdat1$numcases, xtilde = pdat1$xtilde,
                      c = pdat1$c, errors = "processing")
fit2$estimates


}
\references{
Lyles, R.H., Van Domelen, D.R., Mitchell, E.M. and Schisterman, E.F. (2015)
"A discriminant function approach to adjust for processing and measurement
error When a biomarker is assayed in pooled samples."
\emph{Int. J. Environ. Res. Public Health} \strong{12}(11): 14723--14740.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.
}
