% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_snpQ1rw}
\alias{compute_snpQ1rw}
\alias{.compute_snpQ1rw}
\title{compute_snpQ1rw}
\usage{
.compute_snpQ1rw(refcount, totcount, weight, sampsize, readcount, verbose)
}
\arguments{
\item{refcount}{Matrix of nsnpxnpop with counts (genotype or reads) for the reference allele}

\item{totcount}{Matrix of nsnpxnpop with total counts or read coverages}

\item{weight}{Vector of length npop giving the weighting scheme (w=1 for allele count data and w=poolsize/(poolsize-1) for PoolSeq data)}

\item{sampsize}{Vector of length npop giving the haploid sample size (not used for count data)}

\item{readcount}{Logical (if TRUE PoolSeq data assumed i.e. weights depending on haploid size, otherwise weights depend on total counts)}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a vector of length nsnps with SNP-specific Q1
}
\description{
Compute SNP-specific Q1 over all samples using weighting averages of pop. Q1 (eq. A46 in Hivert et al., 2018)
}
\details{
Compute all the SNP-specific Q1 over all pop. samples using weighting averages of pop. Q1 as in eq. A46 of Hivert et al., 2018 (useful for Fst computation with method Identity).
}
\examples{
#
}
