% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering.R
\name{cluster}
\alias{cluster}
\title{K-means Clustering}
\usage{
cluster(RawData = data.frame, K = 2)
}
\arguments{
\item{RawData}{A data frame containing the raw data as read in by
\link{LoadData}}

\item{K}{An integer specifying the number of clusters.}
}
\value{
A list containing the results of the K-means cluster analysis,
including cluster assignments and original data.
}
\description{
K-means Clustering
}
\examples{
genetic_data <- data.frame(
Locus = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
Locus_allele = c("Marker1", "n", 1, 2, 3, "Marker2", "n", 1, 2, 3),
Sample1 = c(NA, 10, 0.5, 0.5, 0, NA, 10, 0.2, 0.3, 0.5),
Sample2 = c(NA, 20, 0.1, 0.2, 0.7, NA, 20, 0.3, 0.4, 0.3),
Sample3 = c(NA, 30, 0.3, 0.4, 0.3, NA, 30, 0.4, 0.2, 0.4)
)
cluster(RawData=genetic_data, K=2)
}
