% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R, R/traj_match.R
\name{trajectory}
\alias{trajectory}
\alias{trajectory,missing-method}
\alias{trajectory,ANY-method}
\alias{trajectory-pomp}
\alias{trajectory,pomp-method}
\alias{trajectory-traj_match_objfun}
\alias{trajectory,traj_match_objfun-method}
\title{Trajectory of a deterministic model}
\usage{
\S4method{trajectory}{pomp}(
  object,
  params,
  times,
  t0,
  format = c("array", "data.frame"),
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{trajectory}{traj_match_objfun}(object, ..., verbose = getOption("verbose", FALSE))
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{times}{a numeric vector (length \code{ntimes}) containing times at which the itineraries are desired.
These must be in non-decreasing order with \code{times[1]>t0}.}

\item{t0}{the time at which the initial conditions are assumed to hold.}

\item{format}{the format in which to return the results.

\code{format = "array"} causes the trajectories to be returned
in a rank-3 array with dimensions
\code{nvar} x \code{ncol(params)} x \code{ntimes}.
Here, \code{nvar} is the number of state variables and \code{ntimes} the length of the argument \code{times}.

\code{format = "data.frame"} causes the results to be returned as a single data frame containing
the time and states.
An ordered factor variable, \sQuote{.id}, distinguishes the trajectories from one another.}

\item{...}{Additional arguments are passed to the ODE integrator (if the skeleton is a vectorfield) and are ignored if it is a map.
See \code{\link[deSolve]{ode}} for a description of the additional arguments accepted by the ODE integrator.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{trajectory} returns an array of dimensions \code{nvar} x \code{nrep} x \code{ntimes}.
If \code{x} is the returned matrix, \code{x[i,j,k]} is the i-th component of the state vector at time \code{times[k]} given parameters \code{params[,j]}.
}
\description{
Compute trajectories of the deterministic skeleton of a Markov process.
}
\details{
In the case of a discrete-time system, the deterministic skeleton is a map and a trajectory is obtained by iterating the map.
In the case of a continuous-time system, the deterministic skeleton is a vector-field;
\code{trajectory} uses the numerical solvers in \pkg{\link[deSolve]{deSolve}} to integrate the vectorfield.

Note that the handling of \code{\dots} in \code{trajectory} differs from that of most other functions in \pkg{pomp}.
In particular, it is not possible to modify the model structure in a call to \code{trajectory}.
}
\seealso{
\code{\link{skeleton}}, \code{\link{flow}}
}
