% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_mean.R
\docType{methods}
\name{filter.mean}
\alias{filter.mean}
\alias{filter.mean,ANY-method}
\alias{filter.mean,missing-method}
\alias{filter.mean-kalmand_pomp}
\alias{filter.mean,kalmand_pomp-method}
\alias{filter.mean-pfilterd_pomp}
\alias{filter.mean,pfilterd_pomp-method}
\title{Filtering mean}
\usage{
\S4method{filter.mean}{kalmand_pomp}(object, vars, ...)

\S4method{filter.mean}{pfilterd_pomp}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{\dots}{ignored}
}
\description{
The mean of the filtering distribution
}
\details{
The filtering distribution is that of
\deqn{X_t \vert Y_1=y^*_1,\dots,Y_t=y^*_t,}{Xt | Y1=y1*,\dots,Yt=yt*,}
where \eqn{X_t}{Xt}, \eqn{Y_t}{Yt} are the latent state and observable processes, respectively, and \eqn{y^*_t}{yt*} is the data, at time \eqn{t}.

The filtering mean is therefore the expectation of this distribution
\deqn{E[X_t \vert Y_1=y^*_1,\dots,Y_t=y^*_t].}{E[Xt | Y1=y1*,\dots,Yt=yt*].}
}
\seealso{
Other particle filter methods: \code{\link{bsmc2}},
  \code{\link{cond.logLik}}, \code{\link{eff.sample.size}},
  \code{\link{filter.traj}}, \code{\link{mif2}},
  \code{\link{pfilter}}, \code{\link{pmcmc}},
  \code{\link{pred.mean}}, \code{\link{pred.var}}
}
\concept{particle filter methods}
