% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{linkage}
\alias{linkage}
\title{Calculate recombination frequency, LOD and phase}
\usage{
linkage(
  dosage_matrix,
  markertype1 = c(1, 0),
  markertype2 = NULL,
  target_parent = "P1",
  other_parent = "P2",
  G2_test = FALSE,
  convert_palindrome_markers = TRUE,
  LOD_threshold = 0,
  ploidy,
  ploidy2 = NULL,
  pairing = c("random", "preferential"),
  prefPars = c(0, 0),
  combinations_per_iter = NULL,
  iter_RAM = 500,
  ncores = 1,
  verbose = TRUE,
  full_output = FALSE,
  log = NULL
)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{markertype1}{A vector of length 2 specifying the first markertype to compare. The first element specifies the dosage in \code{target_parent}, the second in \code{other_parent}.}

\item{markertype2}{A vector of length 2 specifying the first markertype to compare. This argument is optional. If not specified, the function will calculate
linkage within the markertype as specified by \code{markertype1}.
The first element specifies the dosage in \code{target_parent}, the second in \code{other_parent}.}

\item{target_parent}{Character string specifying the target parent as provided in the column-names of dosage_matrix. Target in this context means that you wish
to estimate linkage between markers with an allele that is polymorphic and segregating in this parent.}

\item{other_parent}{Character string specifying the other parent as provided in the column-names of dosage_matrix}

\item{G2_test}{Apply a G2 test (LOD of independence) in addition to the LOD of linkage.}

\item{convert_palindrome_markers}{Logical. Should markers that behave the same for both parents be converted to a workable format for that parent? E.g.: should 3.1 markers be converted to 1.3? If unsure, set to TRUE.}

\item{LOD_threshold}{Minimum LOD score of linkages to report. Recommended to use for large number (> millions) of marker comparisons in order to reduce memory usage.}

\item{ploidy}{Integer. The ploidy of the target parent (parent 1). If parent 2 has the same ploidy level, then also the ploidy level of parent 2.}

\item{ploidy2}{Integer, by default \code{NULL}. If parental ploidies differ, use this to specify the ploidy of parent 2. Note that in cross-ploidy situations, ploidy2 must be smaller than ploidy.}

\item{pairing}{Type of pairing. \code{"random"} or \code{"preferential"}.}

\item{prefPars}{The estimates for preferential pairing parameters for the target and other parent, respectively, in range 0 <= p < 2/3. By default this is c(0,0) (so, no preferential pairing).
See the function \code{\link{test_prefpairing}} and the vignette for more details.}

\item{combinations_per_iter}{Optional integer. Number of marker combinations per iteration.}

\item{iter_RAM}{A (very) conservative estimate of working memory in megabytes used per core. It only takes the size frequency matrices into account. Actual usage is more, especially with large number of linkages that are reported. Reduce memory usage by using a higher LOD_threshold.}

\item{ncores}{Number of cores to use. Works both for Windows and UNIX (using \code{doParallel}). Use \code{parallel::detectCores()} to find out how many cores you have available.}

\item{verbose}{Should messages be sent to stdout?}

\item{full_output}{Logical, by default \code{FALSE}. If \code{TRUE}, the complete output over all phases and showing marker combination counts is returned.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Returns a data.frame with columns:
\describe{
\item{marker_a}{
  first marker of comparison. If markertype2 is specified, it has the type of markertype1.
}
\item{marker_b}{
  second marker of comparison. It has the type of markertype2 if specified.
}
\item{r}{
  (estimated) recombinations frequency
}
\item{LOD}{
  (estimated) LOD score
}
\item{phase}{
  phase between markers
}
}
}
\description{
\code{linkage} is used to calculate recombination frequency, LOD and phase within one type of marker or between two types of markers.
}
\examples{
data("screened_data3")
SN_SN_P1 <- linkage(dosage_matrix = screened_data3,
                   markertype1 = c(1,0),
                   target_parent = "P1",
                   other_parent = "P2",
                   ploidy = 4,
                   pairing = "random",
                   ncores = 1
                   )
}
