% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bw_cv_polysph}
\alias{bw_cv_polysph}
\title{Cross-validation bandwidth selection for polyspherical kernel
density estimator}
\usage{
bw_cv_polysph(X, d, kernel = 1, kernel_type = 1, k = 10,
  type = c("LCV", "LSCV")[1], M = 10000, bw0 = NULL, na.rm = FALSE,
  ncores = 1, h_min = 0, upscale = FALSE, deriv = 0, ...)
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{type}{cross-validation type, either \code{"LCV"} (default) or
\code{"LSCV"}.}

\item{M}{Monte Carlo samples to use for approximating the integral in
the LSCV loss.}

\item{bw0}{initial bandwidth for minimizing the CV loss. If \code{NULL}, it
is computed internally by magnifying the \code{\link{bw_rot_polysph}}
bandwidths by 50\%.}

\item{na.rm}{remove \code{NA}s in the objective function? Defaults to
\code{FALSE}.}

\item{ncores}{number of cores used during the optimization. Defaults to
\code{1}.}

\item{h_min}{minimum h enforced (componentwise). Defaults to \code{0}.}

\item{upscale}{rescale the resulting bandwidths to work for derivative
estimation? Defaults to \code{FALSE}.}

\item{deriv}{derivative order to perform the upscaling. Defaults to \code{0}.}

\item{...}{further arguments passed to \code{\link{optim}}
(if \code{ncores = 1}) or \code{\link[optimParallel]{optimParallel}}
(if \code{ncores > 1}).}
}
\value{
A list as \code{\link[stats]{optim}} or
\code{\link[optimParallel]{optimParallel}} output. In particular, the
optimal bandwidth is stored in \code{par}.
}
\description{
Likelihood Cross-Validation (LCV) and Least Squares
Cross-Validation (LSCV) bandwidth selection for the polyspherical kernel
density estimator.
}
\examples{
n <- 50
d <- 1:2
kappa <- rep(10, 2)
X <- r_vmf_polysph(n = n, d = d, mu = r_unif_polysph(n = 1, d = d),
                   kappa = kappa)
bw_cv_polysph(X = X, d = d, type = "LCV")$par
bw_cv_polysph(X = X, d = d, type = "LSCV")$par
}
