% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linguee_translation_examples.R
\name{linguee_translation_examples}
\alias{linguee_translation_examples}
\title{Provide translation examples using Linguee Translation API}
\usage{
linguee_translation_examples(
  query,
  src,
  dst,
  guess_direction = FALSE,
  follow_corrections = "always"
)
}
\arguments{
\item{query}{The word or phrase for which you want translation examples.}

\item{src}{The source language of the word or phrase. Accepts language codes such as "en", "es", "fr", etc.}

\item{dst}{The target language for the translation examples. Accepts language codes such as "en", "es", "fr", etc.}

\item{guess_direction}{A boolean flag that determines whether the API should guess the translation direction.
The default value is FALSE.}

\item{follow_corrections}{Specifies how to treat responses with a "did you mean" link.
Possible values are "always", "never", or "on_empty_translations".
The default value is "always".}
}
\value{
A dataframe of translation examples with columns: source, target, pos.
}
\description{
Provide translation examples using Linguee Translation API
}
\examples{
\donttest{
linguee_translation_examples(query = "hello", src = "en", dst = "es")
}

}
\seealso{
linguee_word_translation
}
