% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reads.R
\name{sim_reads}
\alias{sim_reads}
\title{Simulation of sequencing read counts and genotypes}
\usage{
sim_reads(pVec, N_ind, coverage, ploidy, error)
}
\arguments{
\item{pVec}{A vector of allele frequencies strung together using the concatenate function.}

\item{N_ind}{The number of individuals to simulate.}

\item{coverage}{The average number of sequences simulated per individual per locus (Poisson distributed).}

\item{ploidy}{The ploidy level of individuals in the population.}

\item{error}{The level of sequencing error. A fixed constant.}
}
\value{
A list of 3 matrices:
\describe{
 \item{\code{genos}}{A matrix of the simulated genotypes.}
 \item{\code{tot_read_mat}}{A matrix of the simulated number of total reads.}
 \item{\code{ref_read_mat}}{A matrix of the simulated number of reference reads.}
 }
}
\description{
Simulates genotypes and read counts under the model of Blischak \emph{et al}.
}
\details{
Total reads are simulated using a Poisson distribution with mean equal to the \code{coverage} set by the user.
Next, genotypes are simulated for the specified number of individuals using the vector of allele frequencies provided to the function.
The number of loci simulated is equal to the number of elements supplied by the vector of allele frequencies.
The number of reference reads is then simulated using Eq. 1 from Blischak \emph{et al}. using the total reads, genotypes and sequencing error.
}
\references{
Blischak PD, Kubatko LS, Wolfe AD. 2015. Accounting for genotype uncertainty in the estimation of allele frequencies in autopolyploids. \emph{In review}. bioRxiv, \strong{doi}:####.
}

