% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyfreqs.R
\name{polyfreqs}
\alias{polyfreqs}
\title{Bayesian population genomics in autopolyploids}
\usage{
polyfreqs(tM, rM, ploidy, iter = 1e+05, thin = 100, burnin = 20,
  print = 1000, error = 0.01, genotypes = FALSE, geno_dir = "genotypes",
  col_header = "", outfile = "polyfreqs-mcmc.out", quiet = FALSE)
}
\arguments{
\item{tM}{Total reads matrix: matrix containing the total number of reads mapping to each locus for each individual.}

\item{rM}{Reference reads marix: matrix containing the number of reference reads mapping to each locus for each individual.}

\item{ploidy}{The ploidy level of individuals in the population (must be >= 2).}

\item{iter}{The number of MCMC generations to run (default=100,000).}

\item{thin}{Thins the MCMC output by sampling everything \code{thin} generations (default=100).}

\item{burnin}{Percent of the posterior samples to discard as burn-in (default=20).}

\item{print}{Frequency of printing the current MCMC generation to stdout (default=1000).}

\item{error}{The level of sequencing error. A fixed constant (default=0.01).}

\item{genotypes}{Logical variable indicating whether or not to print the values of the genotypes sampled during the MCMC (default=FALSE).}

\item{geno_dir}{File path to directory containing the posterior samples of genotypes output by \code{\link{polyfreqs}} (default = "genotypes").}

\item{col_header}{Optional column header tag for use in running loci in parallel (default="").}

\item{outfile}{The name of the ouput file that samples from the posterior distribution of allele frequencies are written to (default="polyfreqs-mcmc.out").}

\item{quiet}{Suppress the printing of the current MCMC generation to stdout (default=FALSE).}
}
\value{
Returns a list of 3 (4 if \code{genotypes=TRUE}) items:
\describe{
 \item{\code{posterior_freqs}}{A matrix of the posterior samples of allele frequencies. These are also printed to the file with the name given by the \code{outfile} argument.}
 \item{\code{map_genotypes}}{If \code{genotypes=TRUE}, then a fourth item will be returned as a matrix containing the maximum \emph{a posteriori} genotype estimates accounting for burn-in.}
 \item{\code{het_obs}}{Matrix of posterior samples of observed heterozygosity.}
 \item{\code{het_exp}}{Matrix of posterior samples of expected heterozygosity.}
 }
}
\description{
\code{polyfreqs} implements a Gibbs sampling algorithm to perform Bayesian inference on the allele frequencies (and other quantities) in a population of autopolyploids.
It is the main function for conducting inference with the \code{polyfreqs} package.
}
\details{
Data sets run through \code{polyfreqs} must be of class "matrix" with row names representing the names of the individuals sampled.
The simplest way to get data into R for running an analysis is to format the total read matrix and reference read matrix as tab delimited text files with the first column containing the individual names and one column after that with the read counts for each locus. These data can then be read in using the \code{read.table} function with the \code{row.names} argument set equal to 1.
An optional tab delimited list of locus names can be included as the first row and are treated as column headers for each locus (set \code{header=T} in the \code{read.table} function).
When running the \code{polyfreqs}, there are a number of options that control what the function returns.
To estimate genotypes and print posterior genotype samples to file, set the \code{genotypes} argument to \code{TRUE} and select a name for the output directory \code{geno_dir} (defaults to "\code{genotypes}").
\code{polyfreqs} also prints the current MCMC generation (with a frequency set by the \code{print_freqs} argument) to the R console so that users can track run times.
This print can be turned off by setting \code{quiet=TRUE}. More details on using \code{polyfreqs} can be found in the introductory vignette.
}
\examples{
data(total_reads)
data(ref_reads)
polyfreqs(total_reads,ref_reads,4,iter=100,thin=10)

}
\author{
Paul Blischak
}
\references{
Blischak PD, LS Kubatko and AD Wolfe. Accounting for genotype uncertainty in the estimation of allele frequencies in autopolyploids. \emph{In revision}.
}

