% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_attributes.R
\docType{methods}
\name{s_attributes}
\alias{s_attributes}
\alias{s_attributes,character-method}
\alias{s_attributes,corpus-method}
\alias{s_attributes,slice-method}
\alias{s_attributes,partition-method}
\alias{s_attributes,subcorpus-method}
\alias{s_attributes,call-method}
\alias{s_attributes,remote_corpus-method}
\alias{s_attributes,remote_partition-method}
\title{Get s-attributes.}
\usage{
s_attributes(.Object, ...)

\S4method{s_attributes}{character}(.Object, s_attribute = NULL, unique = TRUE, regex = NULL, ...)

\S4method{s_attributes}{corpus}(.Object, s_attribute = NULL, unique = TRUE, regex = NULL, ...)

\S4method{s_attributes}{slice}(.Object, s_attribute = NULL, unique = TRUE, ...)

\S4method{s_attributes}{partition}(.Object, s_attribute = NULL, unique = TRUE, ...)

\S4method{s_attributes}{subcorpus}(.Object, s_attribute = NULL, unique = TRUE, ...)

\S4method{s_attributes}{call}(.Object, corpus)

\S4method{s_attributes}{remote_corpus}(.Object, ...)

\S4method{s_attributes}{remote_partition}(.Object, ...)
}
\arguments{
\item{.Object}{A \code{corpus}, \code{subcorpus}, \code{partition} object, or
a \code{call}. A corpus can also be specified by a length-one
\code{character} vector.}

\item{...}{To maintain backward compatibility, if argument \code{sAttribute}
(deprecated) is used. If \code{.Object} is a \code{remote_corpus} or
\code{remote_subcorpus} object, the three dots (\code{...}) are used to
pass arguments. Hence, it is necessary to state the names of all arguments
to be passed explicity.}

\item{s_attribute}{The name of a specific s-attribute.}

\item{unique}{A \code{logical} value, whether to return unique values.}

\item{regex}{A regular expression passed into \code{grep} to filter return
value by applying a regex.}

\item{corpus}{A \code{corpus}-object or a length one character vector
denoting a corpus.}
}
\value{
A character vector (s-attributes, or values of s-attributes).
}
\description{
Structural annotations (s-attributes) of a corpus capture metainformation for
regions of tokens. The \code{s_attributes}-method offers high-level access to
the s-attributes present in a \code{corpus} or \code{subcorpus}, or the values of
s-attributes in a \code{corpus}/\code{partition}.
}
\details{
Importing XML into the Corpus Workbench (CWB) turns elements and element
attributes into so-called "s-attributes". There are two basic uses of the
\code{s_attributes}-method: If the argument \code{s_attribute} is \code{NULL}
(default), the return value is a \code{character} vector with all
s-attributes present in a corpus.

If \code{s_attribute} is the name of a specific s-attribute (a length-one
character vector), the values of the s-attributes available in the
\code{corpus}/\code{partition} are returned.

If argument \code{unique} is \code{FALSE}, the full sequence of the
s_attributes is returned, which is a useful building block for decoding a
corpus.

If argument \code{s_attributes} is a character providing several s-attributes, the method
will return a \code{data.table}. If \code{unique} is \code{TRUE}, all unique
combinations of the s-attributes will be reported by the \code{data.table}.

If \code{.Object} is a call, the \code{s_attributes}-method will
  return a character vector with the s-attributes occurring in the call. This
  usage is relevant internally to implement the \code{subset} method to
  generate a \code{subcorpus} using non-standard evaluation. Usually it will
  not be relevant in an interactive session.
}
\examples{
use("polmineR")

s_attributes("GERMAPARLMINI")
s_attributes("GERMAPARLMINI", "date") # dates of plenary meetings
s_attributes("GERMAPARLMINI", s_attribute = c("date", "party"))  
s_attributes(corpus("GERMAPARLMINI"))
p <- partition("GERMAPARLMINI", date = "2009-11-10")
s_attributes(p)
s_attributes(p, "speaker") # get names of speakers

# Get s-attributes occurring in a call
s_attributes(quote(grep("Merkel", speaker)), corpus = "GERMAPARLMINI")
s_attributes(quote(speaker == "Angela Merkel"), corpus = "GERMAPARLMINI")
s_attributes(quote(speaker != "Angela Merkel"), corpus = "GERMAPARLMINI")
s_attributes(
  quote(speaker == "Angela Merkel" & date == "2009-10-28"),
  corpus = "GERMAPARLMINI"
)
}
