% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topline.R
\name{topline}
\alias{topline}
\title{weighted topline}
\usage{
topline(
  df,
  variable,
  weight,
  remove = c(""),
  n = TRUE,
  pct = TRUE,
  valid_pct = TRUE,
  cum_pct = TRUE
)
}
\arguments{
\item{df}{The data source}

\item{variable}{the variable name}

\item{weight}{The weighting variable, defaults to zwave_weight}

\item{remove}{An optional character vector of values to remove from final table (e.g. "refused").
This will not affect any calculations made. The vector is not case-sensitive.}

\item{n}{logical, if TRUE a frequency column is included
percentages, but in a separate row for column percentages.}

\item{pct}{logical, if TRUE a column of percents is included}

\item{valid_pct}{logical, if TRUE a column of valid percents is included}

\item{cum_pct}{logical, if TRUE a column of cumulative percents is included}
}
\value{
a tibble
}
\description{
\code{topline} returns a tibble containing a weighted topline of one variable
}
\details{
By default the table includes a column for frequency count, percent, valid percent, and cumulative percent.
}
\examples{
topline(illinois, sex, weight)
topline(illinois, sex, weight, pct = FALSE)
}
