% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy_app.R
\name{deploy_app}
\alias{deploy_app}
\title{Deploy a Shiny app to Polished Hosting}
\usage{
deploy_app(
  app_name,
  app_dir = ".",
  api_key = getOption("polished")$api_key,
  api_url = "https://host-api.polished.tech",
  launch_browser = TRUE,
  region = "us-east1",
  ram_gb = 2,
  r_ver = NULL
)
}
\arguments{
\item{app_name}{You Shiny app's name.}

\item{app_dir}{The path to the directory containing your Shiny app.}

\item{api_key}{Your polished.tech API key.  Defaults to \code{getOption("polished")$api_key}.}

\item{api_url}{The Polished API url.  Defaults to "https://host-api.polished.tech".  You should
not change from the default unless you are testing a development version of the API.}

\item{launch_browser}{Whether or not to open your default browser to your newly deployed app
after it is successfully deployed.  \code{TRUE} by default.}

\item{region}{the region to deploy the app to on Google Cloud Platform.  See
\url{https://cloud.google.com/compute/docs/regions-zones} for all available regions
on Google Cloud Platform.  Currently on "us-east1" is supported, but soon, all regions
will be supported.}

\item{ram_gb}{the amount of memory to allocate to your Shiny app server. Valid values are
2, 4, or 8.}

\item{r_ver}{Character string of R version.  If kept as \code{NULL}, the default, then
\code{deploy_app()} will detect the R version you are currently running.  The R version must be a version
supported by an r-ver Docker image.  You can see all the r-ver Docker image versions
of R here \url{https://github.com/rocker-org/rocker-versioned2/tree/master/dockerfiles} and here
\code{https://github.com/rocker-org/rocker-versioned/tree/master/r-ver}.}
}
\description{
Deploy a Shiny app to Polished Hosting
}
\examples{

\dontrun{
deploy_app(
  app_name = "polished_example_01",
  app_dir = system.file("examples/polished_example_01", package = "polished"),
  api_key = "<your polished.tech API key>"
)
}


}
