% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_tools.R
\name{extract_context}
\alias{extract_context}
\title{Extract context for string matches}
\usage{
extract_context(match, v, level = "sentences", n = 1)
}
\arguments{
\item{match}{Character string to be matched.
For multiple strings, please use "|" as a separator.}

\item{v}{Text vector or annotated data frame.}

\item{level}{At which text level do you want matches to be returned?
Defaults to "sentences".
Options are sentences, words, and paragraph.}

\item{n}{Number of sentences or words matched before and after string match.
Defaults to 1.
That is, one word or one sentence before, and after, string match.
For paragraphs, n is always set to one.}
}
\value{
A list of string matches and their context.
}
\description{
A function for getting string matches and the context in which they occur.
}
\examples{
\donttest{
extract_context(match = "war|weapons of mass destruction|conflict|NATO|peace",
                v = US_News_Conferences_1960_1980$text[100],
                level = "sentences", n = 2)
}
}
