% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions__eager.R
\name{pl_concat}
\alias{pl_concat}
\title{Concat polars objects}
\arguments{
\item{l}{list of DataFrame, or Series, LazyFrame or Expr}

\item{rechunk}{perform a rechunk at last}

\item{how}{choice of bind direction "vertical"(rbind) "horizontal"(cbind) "diagonal" diagonally}

\item{parallel}{BOOL default TRUE, only used for LazyFrames}
}
\value{
DataFrame, or Series, LazyFrame or Expr
}
\description{
Concat polars objects
}
\examples{
# vertical
l_ver = lapply(1:10, function(i) {
  l_internal = list(
    a = 1:5,
    b = letters[1:5]
  )
  pl$DataFrame(l_internal)
})
pl$concat(l_ver, how = "vertical")


# horizontal
l_hor = lapply(1:10, function(i) {
  l_internal = list(
    1:5,
    letters[1:5]
  )
  names(l_internal) = paste0(c("a", "b"), i)
  pl$DataFrame(l_internal)
})
pl$concat(l_hor, how = "horizontal")
# diagonal
pl$concat(l_hor, how = "diagonal")
}
