% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_extract}
\alias{ExprStr_extract}
\alias{expr_str_extract}
\title{extract}
\arguments{
\item{pattern}{A valid regex pattern}

\item{group_index}{Index of the targeted capture group.
Group 0 mean the whole pattern, first group begin at index 1.
Default to the first capture group.}
}
\value{
Utf8 array. Contain null if original value is null or regex capture nothing.
}
\description{
Extract the target capture group from provided patterns.
}
\examples{
df = pl$DataFrame(
  a = c(
    "http://vote.com/ballon_dor?candidate=messi&ref=polars",
    "http://vote.com/ballon_dor?candidat=jorginho&ref=polars",
    "http://vote.com/ballon_dor?candidate=ronaldo&ref=polars"
  )
)
df$select(
  pl$col("a")$str$extract(r"(candidate=(\w+))", 1)
)
}
\keyword{ExprStr}
