% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.po}
\alias{print.po}
\title{Print a PO object}
\usage{
\method{print}{po}(x, ...)
}
\arguments{
\item{x}{An object of class \code{po}.}

\item{...}{Arguments passed to \code{\link[tibble]{print.tbl_df}}.}
}
\value{
The \code{x} argument in invisibly returned, but the function is
mostly invoked for the side-effect of printing the \code{x} argument.
}
\description{
\code{\link[base]{print}} method for PO objects.
}
\examples{
pot_file <- system.file("extdata/R-summerof69.pot", package = "poio")
print(pot <- read_po(pot_file))

# Use width = Inf to print all columns in metadata, direct, and countable
print(pot, width = Inf)
}
\seealso{
\code{\link{summary.po}}
}

