% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/norm.plot.R
\name{norm.plot}
\alias{norm.plot}
\title{Plot mean Cropper values and pointer years}
\usage{
norm.plot(list.name, start.yr = NULL, end.yr = NULL,
          sd.disp = FALSE, x.tick.major = 10, x.tick.minor = 5)
}
\arguments{
\item{list.name}{a \code{list} as produced by \code{\link{pointer.norm}}}

\item{start.yr}{an \code{integer} specifying the first year to be plotted. Defaults to the first year included in the \code{out} component of the \code{list} if \code{\var{start.yr}} is \code{NULL}.}

\item{end.yr}{an \code{integer} specifying the last year to be plotted. Defaults to the last year included in the \code{out} component of the \code{list} if \code{\var{end.yr}} is \code{NULL}.}

\item{sd.disp}{a \code{logical} specifying whether error bars (stdev) should be displayed. Defaults to FALSE.}

\item{x.tick.major}{an \code{integer} controlling the major x-axis tick labels. Defaults to 10 years.}

\item{x.tick.minor}{an \code{integer} controlling the minor x-axis ticks. Defaults to 5 years.}
}
\value{
Bar plot.
}
\description{
The function creates a bar plot of mean Cropper values from a \code{list} of the type as produced by \code{\link{pointer.norm}} and highlights years identified as pointer years.
}
\details{
The function makes a plot showing mean Cropper values and pointer years. If event years were defined using \code{method.thresh "Neuwirth"} (\code{\link{pointer.norm}}), different fill colors indicate weak, strong and extreme pointer years, based on the most common event year class. Error bars can be set.
}
\examples{
## Plot mean Cropper values and pointer years (method "Cropper")
data(s033)
py_c <- pointer.norm(s033, window = 5, method.thresh = "Cropper",
                     series.thresh = 75)
norm.plot(py_c, start.yr = 1950, end.yr = NULL,
          sd.disp = FALSE, x.tick.major = 10, x.tick.minor = 5)

## Plot mean Cropper values and pointer years (method "Neuwirth")
data(s033)
py_n <- pointer.norm(s033, window = 5, method.thresh = "Neuwirth",
                     series.thresh = 75)
norm.plot(py_n, start.yr = 1950, end.yr = NULL,
          sd.disp = FALSE, x.tick.major = 10, x.tick.minor = 5)
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}

