% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_get.R
\name{pocket_get}
\alias{pocket_get}
\title{pocket_get}
\usage{
pocket_get(
  favorite = NULL,
  item_type = NULL,
  tag = NULL,
  state = "all",
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{favorite}{boolean. Default NULL. Allows to filter for favorited items. If TRUE, only favorited items will be returned. If FALSE, only un-favorited items will be returned.}

\item{item_type}{character. Default NULL. Allows to filter for content type of items. Valid values are: "image", "article", "video". Please note that there might be Pocket items that do not belong to any of those types. The Pocket API documentation only mentions those three.}

\item{tag}{character. Default NULL. Only one tag can be filtered at a time. Set to '_untagged_' if you only want to get untagged items.}

\item{state}{character. Default "all". Allows to filter on unread/archived items or return all. Valid values are "unread", "archive", "all".}

\item{consumer_key}{character. Your Pocket consumer key. Defaults to Sys.getenv("POCKET_CONSUMER_KEY").}

\item{access_token}{character. Your Pocket request token. Defaults to Sys.getenv("POCKET_ACCESS_TOKEN").}
}
\value{
tibble. Tibble with one row for each Pocket item.
}
\description{
Get a data frame with your pocket data.
}
\details{
See https://getpocket.com/developer/docs/v3/retrieve for the meaning of certain variable values.
}
