% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derived_3cpt.R
\name{calc_derived_3cpt}
\alias{calc_derived_3cpt}
\title{Calculate derived pharmacokinetic parameters for a 3-compartment linear model}
\usage{
calc_derived_3cpt(CL, V1, V2, V3, Q2, Q3, type = "all", sigdig = 5)
}
\arguments{
\item{CL}{Clearance (L/h)}

\item{V1}{Central volume of distribution (L)}

\item{V2}{First peripheral volume of distribution (L)}

\item{V3}{Second peripheral volume of distribution (L)}

\item{Q2}{Intercompartmental clearance from central to first peripheral compartment (L/h)}

\item{Q3}{Intercompartmental clearance from central to second peripheral compartment (L/h)}

\item{type}{Type of half-life to return (\code{"Vss"}, \code{"k10"}, \code{"k12"}, \code{"k13"}, \code{"k21"}, \code{"k31"}, \code{"thalf_alpha"}, \code{"thalf_beta"}, \code{"thalf_gamma"}, \code{"alpha"}, \code{"beta"}, \code{"gamma"}, \code{"trueA"}, \code{"trueB"}, \code{"trueC"}, \code{"fracA"}, \code{"fracB"}, \code{"fracC"}, \code{"all"}). Default is \code{"all"}).}

\item{sigdig}{Number of significant digits to be returned. Default is 5.}
}
\value{
Return a list of derived PK parameters for a 3-compartment linear model given provided clearances and volumes.
\itemize{ 
  \item \code{Vss}: Volume of distribution at steady state, \eqn{V_{ss}} (L)
  \item \code{k10}: First-order elimination rate, \eqn{k_{10}} (/h)
  \item \code{k12}: First-order rate of transfer from central to first peripheral compartment, \eqn{k_{12}} (/h)
  \item \code{k21}: First-order rate of transfer from first peripheral to central compartment, \eqn{k_{21}} (/h)   
  \item \code{k13}: First-order rate of transfer from central to second peripheral compartment, \eqn{k_{13}} (/h)
  \item \code{k31}: First-order rate of transfer from second peripheral to central compartment,\eqn{k_{31}} (/h)  
  \item \code{thalf_alpha}: \eqn{t_{1/2,\alpha}} (h)
  \item \code{thalf_beta}: \eqn{t_{1/2,\beta}} (h)
  \item \code{thalf_gamma}: \eqn{t_{1/2,\gamma}} (h)
  \item \code{alpha}: \eqn{\alpha}
  \item \code{beta}: \eqn{\beta}
  \item \code{gamma}: \eqn{\beta}
  \item \code{trueA}: true A
  \item \code{trueB}: true B
  \item \code{trueC}: true C
  \item \code{fracA}: fractional A
  \item \code{fracB}: fractional B
  \item \code{fracC}: fractional C
 }
}
\description{
Calculate derived pharmacokinetic parameters for a 3-compartment linear model
}
\examples{
params <- calc_derived_3cpt(CL=29.4, V1=23.4, V2=114, V3=4614, Q2=270, Q3=73)

}
\references{
Shafer S. L. \code{CONVERT.XLS}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
