% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addOutputField.R
\name{addOutputField}
\alias{addOutputField}
\title{Add Output nodes to a PMML object.}
\usage{
addOutputField(xmlmodel = NULL, outputNodes = NULL, at = "End",
  xformText = NULL, nodeName = NULL, attributes = NULL, whichOutput = 1,
  namespace = "4_2")
}
\arguments{
\item{xmlmodel}{The PMML model to which the OutputField elements are to be added}

\item{outputNodes}{The Output nodes to be added. These may be created using the
'makeOutputNodes' helper function}

\item{at}{Given an Output element, the 1 based index after which the given Output
child element should be inserted at}

\item{xformText}{Post-processing information to be included in the OutputField element.
This expression will be processed by the functionToPMML function}

\item{nodeName}{The name of the element to be added}

\item{attributes}{The attributes to be added}

\item{whichOutput}{The name of the OutputField element}

\item{namespace}{The namespace of the PMML model}
}
\value{
Output node with the OutputField elements inserted.
}
\description{
Add Output nodes to a PMML object.
}
\details{
This function is meant to add any post-processing information to an existing model via
the OutputField element. One can also use this to tell the PMML model to output other values
not automatically added to the model output.
  The first method is to use the 'makeOutputNodes' helper function to make a list of output
elements to be added. 'whichOutput' lets the function know which of the Output elements we want to
work with; there may be more than one in a multiple model file. One can then add those elements there,
at the desired index given by the 'at' parameter; the elements are inserted after the OutputField
element at the 'at' index.
  This function can also be used with the 'nodeName' and 'attributes' to add the list of attributes to
an OutputField element with name 'nodeName'
element using the 'xmlmodel', 'outputNodes' and 'at' parameters.
  Finally, one can use this to add the transformation expression given by the 'xformText' parameter
to the node with name 'nodeName'. The string given via 'xformText' is converted to an XML expression similarly
to the functionToPMML function.
}
\examples{
# Load the standard iris dataset
data(iris)

# Create a linear model and convert it to PMML
mod <- lm(Sepal.Length~.,iris)
pmod <- pmml(mod)

# Create additional output nodes
onodes0<-makeOutputNodes(name=list("OutputField","OutputField"),
                         attributes=list(list(name="dbl",
                         optype="continuous"),NULL),
                         expression=list("ln(x)","ln(x/(1-x))"))
onodes2<-makeOutputNodes(name=list("OutputField","OutputField"),
                         attributes=list(list(name="F1",
                         dataType="double",optype="continuous"),
                         list(name="F2")))

# Create new pmml objects with the output nodes appended
addOutputField(xmlmodel=pmod, outputNodes=onodes2, at="End",
               xformText=NULL, nodeName=NULL, attributes=NULL,
               whichOutput=1)
pmod2<-addOutputField(xmlmodel=pmod, outputNodes=onodes0, at="End",
                       xformText=NULL, nodeName=NULL,
                       attributes=NULL,whichOutput=1)

# Create nodes with attributes and transformations
addOutputField(xmlmodel=pmod2, outputNodes=onodes2,at=2)
addOutputField(xmlmodel=pmod2, xformText=list("exp(x) && !x"),
               nodeName="Predicted_Sepal.Length")

att <- list(datype="dbl",optpe="dsc")
addOutputField(xmlmodel=pmod2, nodeName="Predicted_Sepal.Length",
               attributes=att)
}
\author{
Tridivesh Jena
}

