% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inexact_join.R
\name{inexact_join}
\alias{inexact_join}
\alias{inexact_inner_join}
\alias{inexact_left_join}
\alias{inexact_right_join}
\alias{inexact_full_join}
\alias{inexact_semi_join}
\alias{inexact_nest_join}
\alias{inexact_anti_join}
\title{Join two data frames inexactly}
\usage{
inexact_inner_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_left_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_right_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_full_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_semi_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_nest_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  keep = FALSE,
  name = NULL,
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)

inexact_anti_join(
  x,
  y,
  by = NULL,
  copy = FALSE,
  ...,
  var = NULL,
  jvar = NULL,
  method,
  exact = TRUE
)
}
\arguments{
\item{x, y, by, copy, suffix, keep, name, ...}{Arguments to be passed to the relevant \code{join} function.}

\item{var}{Quoted or unquoted variable from the \code{x} data frame which is to be indirectly matched.}

\item{jvar}{Quoted or unquoted variable(s) from the \code{y} data frame which are to be indirectly matched. These cannot be variable names also in \code{x} or \code{var}.}

\item{method}{The approach to be taken in performing the indirect matching.}

\item{exact}{A logical, where \code{TRUE} indicates that exact matches are acceptable. For example, if \code{method = 'last'}, \code{x} contains \code{var = 2}, and \code{y} contains \code{jvar = 1} and \code{jvar = 2}, then \code{exact = TRUE} will match with the \code{jvar = 2} observation, and \code{exact = FALSE} will match with the \code{jvar = 1} observation. If \code{jvar} contains two variables and you want them treated differently, set to \code{c(TRUE,FALSE)} or \code{c(FALSE,TRUE)}.}
}
\description{
These functions are modifications of the standard \code{dplyr} \code{join} functions, except that it allows a variable of an ordered type (like date or numeric) in \code{x} to be matched in inexact ways to variables in \code{y}.
}
\details{
This allows matching, for example, if one data set contains data from multiple days in the week, while the other data set is weekly. Another example might be matching an observation in one data set to the *most recent* previous observation in the other.

The available methods for matching are:

\itemize{
  \item \code{method = "last"} matches \code{var} to the closest value of \code{jvar} that is *lower*.
  \item \code{method = "next"} matches \code{var} to the closest value of \code{jvar} that is *higher*.
  \item \code{method = "closest"} matches \code{var} to the closest value of \code{jvar}, above or below. If equidistant between two values, picks the lower of the two.
  \item \code{method = "between"} requires two variables in \code{jvar} which constitute the beginning and end of a range, and matches \code{var} to the range it is in. Make sure that the ranges are non-overlapping within the joining variables, or else you will get strange results (specifically, it should join to the earliest-starting range). If the end of one range is the exact start of another, \code{exact = c(TRUE,FALSE)} or \code{exact = c(FALSE,TRUE)} is recommended to avoid overlaps. Defaults to \code{exact = c(TRUE,FALSE)}.
}

Note that if, given the method, \code{var} finds no proper match, it will be merged with any \code{is.na(jvar[1])} values.
}
\examples{

data(Scorecard)
# We also have this data on the December unemployment rate for US college grads nationally
# but only every other year
unemp_data <- data.frame(
  unemp_year = c(2006, 2008, 2010, 2012, 2014, 2016, 2018),
  unemp = c(.017, .036, .048, .040, .028, .025, .020)
)
# I want to match the most recent unemployment data I have to each college
Scorecard <- Scorecard \%>\%
  inexact_left_join(unemp_data,
    method = "last",
    var = year,
    jvar = unemp_year
  )

# Or perhaps I want to find the most recent lagged value (i.e. no exact matches, only recent ones)
data(Scorecard)
Scorecard <- Scorecard \%>\%
  inexact_left_join(unemp_data,
    method = "last",
    var = year,
    jvar = unemp_year,
    exact = FALSE
  )

# Another way to do the same thing would be to specify the range of unemp_years I want exactly
data(Scorecard)
unemp_data$unemp_year2 <- unemp_data$unemp_year + 2
Scorecard <- Scorecard \%>\%
  inexact_left_join(unemp_data,
    method = "between",
    var = year,
    jvar = c(unemp_year, unemp_year2)
  )
}
