% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.SPANSRes}
\alias{plot.SPANSRes}
\title{Plot SPANSRes Object}
\usage{
\method{plot}{SPANSRes}(
  x,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = NULL,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  color_low = NULL,
  color_high = NULL,
  Npep_bar = FALSE,
  Npep_color_low = NULL,
  Npep_color_high = NULL,
  bw_theme = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of the class 'SPANSRes', created by
\code{\link{spans_procedure}}}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label.}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is NULL.}

\item{title_lab}{character string specifying the plot title}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{color_low}{character string specifying the color of the gradient for
low values.}

\item{color_high}{character string specifying the color of the gradient for
high values}

\item{Npep_bar}{Boolean for plotting with a color bar}

\item{Npep_color_low}{character string specifying the color of the gradient for
low values.}

\item{Npep_color_high}{character string specifying the color of the gradient for
high values}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'SPANSRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)
data(pep_object)
mypep <- edata_transform(omicsData = pep_object, data_scale = "log2")
mypep <- group_designation(omicsData = mypep, main_effects = "Phenotype")
myspans <- spans_procedure(omicsData = mypep)
plot(myspans)
}
\dontshow{\}) # examplesIf}
}
