% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{pls_fit}
\alias{pls_fit}
\title{Wrapper for mixOmics pls functions}
\usage{
pls_fit(x, y, ncomp = NULL, keepX = NULL, ...)
}
\arguments{
\item{x}{A data frame or matrix of predictors.}

\item{y}{For classification, a factor. For regression, a matrix, vector, or
data frame.}

\item{ncomp}{The number of PLS components. If left null, the maximum possible
is used.}

\item{keepX}{The number of non-zero loadings \emph{per component}. If the value is
a vector, the value is left as-is. Otherwise, the scalar is expanded to be
the same for all components. If NULL, either \code{\link[mixOmics:pls]{mixOmics::pls()}} or
\code{\link[mixOmics:plsda]{mixOmics::plsda()}} are used. Otherwise, their sparse analogs are used.}
}
\value{
A model object generated by \code{\link[mixOmics:pls]{mixOmics::pls()}}, \code{\link[mixOmics:plsda]{mixOmics::plsda()}},
\code{\link[mixOmics:spls]{mixOmics::spls()}}, or \code{\link[mixOmics:splsda]{mixOmics::splsda()}}.
}
\description{
Based on arguments, this wrapper routes the data and arguments to the four
\code{pls} functions that are sparse/dense or regression/classification.
}
\keyword{internal}
