% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.heatmap.R
\name{matrix.heatmap}
\alias{matrix.heatmap}
\title{Heatmap visualization for matrix}
\usage{
matrix.heatmap(mat, ...)
}
\arguments{
\item{mat}{the matrix to visualize}

\item{...}{any argument that could be pass to the functions 
\code{\link[fields]{image.plot}} or \code{\link[graphics]{image}}.}
}
\value{
No return, just plot the heatmap in the current graphic window.
}
\description{
Visualization of matrix entries in heatmap format, the color scale 
depends on the numerical values.
}
\details{
The function \code{matrix.heatmap} is a wrapper for the function 
\code{\link[fields]{image.plot}} from the 'fields' package.
}
\examples{
### load plsgenomics library
library(plsgenomics)

### generate a matrix
A = matrix(runif(10*10), ncol=10)

### heatmap of estimated probabilities
matrix.heatmap(A)

}
\seealso{
\code{\link{logit.spls}}, \code{\link{stability.selection}}, 
\code{\link{stability.selection.heatmap}}
}
\author{
Ghislain Durif (\url{http://thoth.inrialpes.fr/people/gdurif/}).
}
