% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plotly_build}
\alias{plotly_build}
\title{Create a 'plotly_built' object}
\usage{
plotly_build(l = last_plot())
}
\arguments{
\item{l}{a ggplot object, or a plotly_hash object, or a list.}
}
\description{
This generic function creates the list object sent to plotly.js
for rendering. Using this function can be useful for overriding defaults
provided by \code{ggplotly}/\code{plot_ly} or for debugging rendering
errors.
}
\examples{

p <- plot_ly()
# data frame
str(p)
# the actual list of options sent to plotly.js
str(plotly_build(p))

p <- qplot(data = mtcars, wt, mpg, geom = c("point", "smooth"))
l <- plotly_build(p)
# turn off hoverinfo for the smooth (but keep it for the points)
l$data[[2]]$hoverinfo <- "none"
l$data[[3]]$hoverinfo <- "none"
l

}

