% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_journal_roc.R
\name{plot_journal_roc}
\alias{plot_journal_roc}
\title{Plot an ROC curve for use in print}
\usage{
plot_journal_roc(ggroc_p, font.size = 3, n.cuts = 20, ci.at = NULL,
  opacity = 0.3, lty = NULL, color = NULL, lwd = NULL, legend = FALSE)
}
\arguments{
\item{ggroc_p}{An object as returned by \link{ggroc} or \link{multi_ggroc}.
It can be modified with annotations, themes, etc.}

\item{font.size}{Integer that determines font size of cutoff labels}

\item{n.cuts}{Number of cutoffs to display}

\item{ci.at}{Cutoff values at which to plot confidence regions, if non-NULL,
\code{rocdata} must contain limits for the confidence region, as returned
by \link{calculate_roc}}

\item{opacity}{Opacity level for confidence region boxes. Defaults to 0.3. Must be between 0 and 1}

\item{lty}{Optional vector of integers defining line types to apply to curves}

\item{color}{Optional vector of color names to apply to curves}

\item{lwd}{Line widths for curves}

\item{legend}{Logical. If true plots a legend in bottom right corner of plot}
}
\value{
A ggplot object
}
\description{
Given a ggroc object, creates a plot suitable for print.
}

