% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ggroc.R
\name{multi_ggroc}
\alias{multi_ggroc}
\title{Plot multiple ROC curves}
\usage{
multi_ggroc(datalist, fpf_string = rep("FPF", length(datalist)),
  tpf_string = rep("TPF", length(datalist)), c_string = rep("c",
  length(datalist)), label = NULL, legend = FALSE, label.adj.x = rep(0,
  length(datalist)), label.adj.y = rep(0, length(datalist)),
  label.angle = rep(45, length(datalist)), plotmath = FALSE,
  xlabel = "False positive fraction", ylabel = "True positive fraction")
}
\arguments{
\item{datalist}{List of data frames each containing true and false positive
fractions and cutoffs}

\item{fpf_string}{Column names identifying false positive fraction}

\item{tpf_string}{Column names identifying true positive fraction}

\item{c_string}{Column names identifying cutoff values}

\item{label}{Optional vector of direct labels for the ROC curve, same length
as \code{datalist}}

\item{legend}{If true, draws legend instead of labels}

\item{label.adj.x}{Adjustment for the positioning of the label, same length
as \code{datalist}}

\item{label.adj.y}{Adjustment for the positioning of the label, same length
as \code{datalist}}

\item{label.angle}{Adjustment for angle of label, same length as
\code{datalist}}

\item{plotmath}{Logical. If TRUE, labels will be parsed as expressions. See \code{?plotmath} for details.}

\item{xlabel}{Defaults to "False positive fraction"}

\item{ylabel}{Defaults to "True positive fraction"}
}
\value{
A ggplot object
}
\description{
Given a list of results computed by \link{calculate_roc}, plot the curve
using ggplot with sensible defaults. Pass the resulting object and data to
\link{export_interactive_roc}, \link{plot_interactive_roc}, or
\link{plot_journal_roc}.
}

