% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_vcovG.R
\name{vcovHC.plm}
\alias{vcovHC.plm}
\alias{vcovHC.pcce}
\alias{vcovHC.pgmm}
\title{Robust Covariance Matrix Estimators}
\usage{
\method{vcovHC}{plm}(
  x,
  method = c("arellano", "white1", "white2"),
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  cluster = c("group", "time"),
  ...
)

\method{vcovHC}{pcce}(
  x,
  method = c("arellano", "white1", "white2"),
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  cluster = c("group", "time"),
  ...
)

\method{vcovHC}{pgmm}(x, ...)
}
\arguments{
\item{x}{an object of class \code{"plm"} which should be the result of a
random effects or a within model or a model of class \code{"pgmm"}
or an object of class \code{"pcce"},}

\item{method}{one of \code{"arellano"}, \code{"white1"}, \code{"white2"},}

\item{type}{the weighting scheme used, one of \code{"HC0"}, \code{"sss"},
\code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, see Details,}

\item{cluster}{one of \code{"group"}, \code{"time"},}

\item{\dots}{further arguments.}
}
\value{
An object of class \code{"matrix"} containing the estimate of
the asymptotic covariance matrix of coefficients.
}
\description{
Robust covariance matrix estimators \emph{a la White} for panel
models.
}
\details{
\code{vcovHC} is a function for estimating a robust covariance matrix of
parameters for a fixed effects or random effects panel model
according to the White method
\insertCite{WHIT:80,WHIT:84b,AREL:87}{plm}. Observations may be
clustered by \code{"group"} (\code{"time"}) to account for serial
(cross-sectional) correlation.

All types assume no intragroup (serial) correlation between errors
and allow for heteroskedasticity across groups (time periods). As
for the error covariance matrix of every single group of
observations, \code{"white1"} allows for general heteroskedasticity but
no serial (cross--sectional) correlation; \code{"white2"} is \code{"white1"}
restricted to a common variance inside every group (time period)
\insertCite{@see @GREE:03, Sec. 13.7.1-2, @GREE:12, Sec. 11.6.1-2
and @WOOL:02, Sec. 10.7.2}{plm}; \code{"arellano"} \insertCite{@see
ibid. and the original ref. @AREL:87}{plm} allows a fully general
structure w.r.t. heteroskedasticity and serial (cross--sectional)
correlation.

Weighting schemes specified by \code{type} are analogous to those in
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} in package \CRANpkg{sandwich} and are
justified theoretically (although in the context of the standard
linear model) by \insertCite{MACK:WHIT:85;textual}{plm} and
\insertCite{CRIB:04;textual}{plm}
\insertCite{ZEIL:04}{plm}. \code{type = "sss"} employs the small sample
correction as used by Stata.

The main use of \code{vcovHC} is to be an argument to other functions,
e.g.  for Wald--type testing: argument \code{vcov.} to \code{coeftest()},
argument \code{vcov} to \code{waldtest()} and other methods in the
\CRANpkg{lmtest} package; and argument \code{vcov.} to
\code{linearHypothesis()} in the \CRANpkg{car} package (see the
examples). Notice that the \code{vcov} and \code{vcov.} arguments allow to
supply a function (which is the safest) or a matrix
\insertCite{@ZEIL:04, 4.1-2 and examples below}{plm}.

A special procedure for \code{pgmm} objects, proposed by
\insertCite{WIND:05;textual}{plm}, is also provided.
}
\note{
The function \code{pvcovHC} is deprecated. Use \code{vcovHC} for the
same functionality.
}
\examples{

library(lmtest)
library(car)
data("Produc", package = "plm")
zz <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
          data = Produc, model = "random")
## standard coefficient significance test
coeftest(zz)
## robust significance test, cluster by group
## (robust vs. serial correlation)
coeftest(zz, vcov.=vcovHC)
## idem with parameters, pass vcov as a function argument
coeftest(zz, vcov.=function(x) vcovHC(x, method="arellano", type="HC1"))
## idem, cluster by time period
## (robust vs. cross-sectional correlation)
coeftest(zz, vcov.=function(x) vcovHC(x, method="arellano",
 type="HC1", cluster="group"))
## idem with parameters, pass vcov as a matrix argument
coeftest(zz, vcov.=vcovHC(zz, method="arellano", type="HC1"))
## joint restriction test
waldtest(zz, update(zz, .~.-log(emp)-unemp), vcov=vcovHC)
## test of hyp.: 2*log(pc)=log(emp)
linearHypothesis(zz, "2*log(pc)=log(emp)", vcov.=vcovHC)

## Robust inference for CCE models
data("Produc", package = "plm")
ccepmod <- pcce(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc, model="p")
## IGNORE_RDIFF_BEGIN
summary(ccepmod, vcov = vcovHC)
## IGNORE_RDIFF_END

## Robust inference for GMM models
data("EmplUK", package="plm")
ar <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1)
           + log(capital) + lag(log(capital), 2) + log(output)
           + lag(log(output),2) | lag(log(emp), 2:99),
            data = EmplUK, effect = "twoways", model = "twosteps")
rv <- vcovHC(ar)
mtest(ar, order = 2, vcov = rv)
}
\references{
\insertRef{AREL:87}{plm}

\insertRef{CRIB:04}{plm}

\insertRef{GREE:03}{plm}

\insertRef{GREE:12}{plm}

\insertRef{MACK:WHIT:85}{plm}

\insertRef{WIND:05}{plm}

\insertRef{WHIT:84b}{plm}
chap. 6

\insertRef{WHIT:80}{plm}

\insertRef{WOOL:02}{plm}

\insertRef{ZEIL:04}{plm}
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} from the \CRANpkg{sandwich}
package for weighting schemes (\code{type} argument).
}
\author{
Giovanni Millo & Yves Croissant
}
\keyword{regression}
