% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_to_pliman}
\alias{mosaic_to_pliman}
\title{Mosaic to pliman}
\usage{
mosaic_to_pliman(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  rescale = TRUE,
  coef = 0
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and  near-infrared bands
of the image, respectively. By default, the function assumes a BGR as input
(b = 1, g = 2, r = 3). If a multispectral image is provided up to seven
bands can be used to compute built-in indexes. There are no limitation of
band numbers if the index is computed using the band name.}

\item{rescale}{Rescale the final values? If \code{TRUE} the final values are
rescaled so that the maximum value is 1.}

\item{coef}{An addition coefficient applied to the resulting object. This is
useful to adjust the brightness of the final image. Defaults to 0.}
}
\value{
An \code{Image} object with the same number of layers as \code{mosaic}.
}
\description{
Convert an \code{SpatRaster} object to a \code{Image} object with optional scaling.
}
\details{
This function converts \code{SpatRaster} into an \code{Image} object, which
can be used for image analysis in \code{pliman}. Note that if a large
\code{SpatRaster} is loaded, the resulting object may increase considerably the
memory usage.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
# Convert a mosaic raster to an Image object
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
pliman_image <- mosaic_to_pliman(mosaic)
plot(pliman_image)
}

}
