% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_split}
\alias{object_split}
\title{Splits objects from an image into multiple images}
\usage{
object_split(
  img,
  index = "NB",
  lower_size = NULL,
  watershed = TRUE,
  invert = FALSE,
  fill_hull = FALSE,
  filter = 2,
  threshold = "Otsu",
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  edge = 3,
  remove_bg = FALSE,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{index}{A character value specifying the target mode for conversion to
binary image when \code{foreground} and \code{background} are not declared. Defaults
to \code{"NB"} (normalized blue). See \code{\link[=image_index]{image_index()}} for more details. User can
also calculate your own index using the bands names, e.g. \code{index = "R+B/G"}}

\item{lower_size}{Plant images often contain dirt and dust. To prevent dust from
affecting the image analysis, objects with lesser than 10\% of the mean of all objects
are removed. Set \code{lower_limit = 0} to keep all the objects.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{invert}{Inverts the binary image if desired. This is useful to process
images with a black background. Defaults to \code{FALSE}. If \code{reference = TRUE}
is use, \code{invert} can be declared as a logical vector of length 2 (eg.,
\verb{invert = c(FALSE, TRUE}). In this case, the segmentation of objects and
reference from the foreground using \code{back_fore_index} is performed using the
default (not inverted), and the segmentation of objects from the reference
is performed by inverting the selection (selecting pixels higher than the
threshold).}

\item{fill_hull}{Fill holes in the binary image? Defaults to \code{FALSE}. This is
useful to fill holes in objects that have portions with a color similar to
the background. IMPORTANT: Objects touching each other can be combined into
one single object, which may underestimate the number of objects in an
image.}

\item{filter}{Performs median filtering in the binary image? See more at
\code{\link[=image_filter]{image_filter()}}. Defaults to \code{FALSE}. Use a positive integer to define the
size of the median filtering. Larger values are effective at removing noise,
but adversely affect edges.}

\item{threshold}{The theshold method to be used.
\itemize{
\item By default (\code{threshold = "Otsu"}), a threshold value based
on Otsu's method is used to reduce the grayscale image to a binary image. If
a numeric value is informed, this value will be used as a threshold.
\item If \code{threshold = "adaptive"}, adaptive thresholding (Shafait et al. 2008)
is used, and will depend on the \code{k} and \code{windowsize} arguments.
\item If any non-numeric value different than \code{"Otsu"} and \code{"adaptive"} is used,
an iterative section will allow you to choose the threshold based on a
raster plot showing pixel intensity of the index.
}}

\item{extension}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Higher value smooths out small objects.}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest.}

\item{object_size}{The size of the object. Used to automatically set up
\code{tolerance} and \code{extension} parameters. One of the following. \code{"small"}
(e.g, wheat grains), \code{"medium"} (e.g, soybean grains), \code{"large"}(e.g, peanut
grains), and \code{"elarge"} (e.g, soybean pods)`.}

\item{edge}{The number of pixels to be added in the edge of the segmented
object. Defaults to 5.}

\item{remove_bg}{If \code{TRUE}, the pixels that are not part of objects are
converted to white.}

\item{plot}{Show image after processing?}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{...}{Additional arguments passed on to \code{\link[=image_combine]{image_combine()}}}
}
\value{
A list of objects of class \code{Image}.
}
\description{
Using threshold-based segmentation, objects are first isolated from
background. Then, a new image is created for each single object. A list of
images is returned.
}
\examples{
library(pliman)
img <- image_pliman("la_leaves.jpg", plot = TRUE)
imgs <- object_split(img) # set to NULL to use 50\% of the cores

}
\seealso{
\code{\link[=analyze_objects]{analyze_objects()}}, \code{\link[=image_binary]{image_binary()}}
}
