% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{plot_index_shp}
\alias{plot_index_shp}
\title{Plot rectangles colored by a quantitative attribute and overlay on an RGB
image}
\usage{
plot_index_shp(
  object,
  attribute = "coverage",
  color = c("red", "green"),
  alpha = 0.5,
  legend.position = "bottom",
  na.color = "gray",
  classes = 6,
  round = 3,
  horiz = TRUE
)
}
\arguments{
\item{object}{An object computed with \code{\link[=analyze_objects_shp]{analyze_objects_shp()}}.}

\item{attribute}{The name of the quantitative variable in the
\code{object_index} to be used for coloring the rectangles.}

\item{color}{A vector of two colors to be used for the color scale.}

\item{alpha}{The transparency level of the rectangles' color (between 0 and 1).}

\item{legend.position}{The position of the color legend, either
\code{"bottom"} or \code{"right"}.}

\item{na.color}{The color to be used for rectangles with missing values in
the quantitative variable.}

\item{classes}{The number of classes in the color scale.}

\item{round}{The number of decimal places to round the legend values.}

\item{horiz}{Logical, whether the legend should be horizontal (\code{TRUE})
or vertical (\code{FALSE}).}
}
\value{
The function plots rectangles colored by the specified quantitative
variable on top of the RGB image and shows the continuous color legend
outside the plot.
}
\description{
This function plots rectangles on top of an RGB image, where each rectangle
is colored based on a quantitative variable. The quantitative variable is
specified in the \code{attribute} argument and should be present in the
\code{object_index} of the \code{object} computed using \code{\link[=analyze_objects_shp]{analyze_objects_shp()}}. The
rectangles are colored using a color scale.
}
\examples{
if(interactive()){
library(pliman)

# Computes the DGCI index for each flax leaf
flax <- image_pliman("flax_leaves.jpg", plot =TRUE)
res <-
   analyze_objects_shp(flax,
                       buffer_x = 0.2,
                       buffer_y = 0.2,
                       nrow = 3,
                       ncol = 5,
                       plot = FALSE,
                       object_index = "DGCI")
plot(res$final_image)
plot_index_shp(res)
}

}
